/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.spawning;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import lotr.common.LOTRConfig;
import lotr.common.LOTRSpawnDamping;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.world.LOTRWorldChunkManager;
import lotr.common.world.LOTRWorldProvider;
import lotr.common.world.biome.LOTRBiome;
import lotr.common.world.biome.variant.LOTRBiomeVariant;
import lotr.common.world.spawning.LOTRBiomeSpawnList;
import lotr.common.world.spawning.LOTRSpawnEntry;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.ForgeEventFactory;

public class LOTRSpawnerNPCs {
    public static final int expectedChunks = 196;
    private static Set<ChunkCoordIntPair> eligibleSpawnChunks = new HashSet<ChunkCoordIntPair>();
    private static Map<Integer, Integer> ticksSinceCycle = new HashMap<Integer, Integer>();

    public static ChunkPosition getRandomSpawningPointInChunk(World world, ChunkCoordIntPair chunkCoords) {
        int i = chunkCoords.field_77276_a;
        int k = chunkCoords.field_77275_b;
        return LOTRSpawnerNPCs.getRandomSpawningPointInChunk(world, i, k);
    }

    public static ChunkPosition getRandomSpawningPointInChunk(World world, int i, int k) {
        if (!world.func_72863_F().func_73149_a(i, k)) {
            return null;
        }
        Chunk chunk = world.func_72964_e(i, k);
        int i1 = i * 16 + world.field_73012_v.nextInt(16);
        int k1 = k * 16 + world.field_73012_v.nextInt(16);
        int j = world.field_73012_v.nextInt(chunk == null ? world.func_72940_L() : chunk.func_76625_h() + 16 - 1);
        return new ChunkPosition(i1, j, k1);
    }

    public static void getSpawnableChunks(World world, Set<ChunkCoordIntPair> set) {
        set.clear();
        for (Object element : world.field_73010_i) {
            EntityPlayer entityplayer = (EntityPlayer)element;
            int i = MathHelper.func_76128_c((double)(entityplayer.field_70165_t / 16.0));
            int k = MathHelper.func_76128_c((double)(entityplayer.field_70161_v / 16.0));
            for (int i1 = -7; i1 <= 7; ++i1) {
                for (int k1 = -7; k1 <= 7; ++k1) {
                    ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(i + i1, k + k1);
                    set.add(chunkcoordintpair);
                }
            }
        }
    }

    public static void getSpawnableChunksWithPlayerInRange(World world, Set<ChunkCoordIntPair> set, int range) {
        LOTRSpawnerNPCs.getSpawnableChunks(world, set);
        ArrayList<EntityPlayer> validPlayers = new ArrayList<EntityPlayer>();
        for (Object obj : world.field_73010_i) {
            EntityPlayer entityplayer = (EntityPlayer)obj;
            if (entityplayer.field_71075_bZ.field_75098_d) continue;
            validPlayers.add(entityplayer);
        }
        int height = world.func_72800_K();
        HashSet<ChunkCoordIntPair> removes = new HashSet<ChunkCoordIntPair>();
        for (ChunkCoordIntPair chunkCoords : set) {
            int i = chunkCoords.func_77273_a();
            int k = chunkCoords.func_77274_b();
            AxisAlignedBB playerCheckBox = AxisAlignedBB.func_72330_a((double)(i - range), (double)0.0, (double)(k - range), (double)(i + range), (double)height, (double)(k + range));
            boolean anyPlayers = false;
            for (EntityPlayer entityplayer : validPlayers) {
                if (!entityplayer.field_70121_D.func_72326_a(playerCheckBox)) continue;
                anyPlayers = true;
                break;
            }
            if (anyPlayers) continue;
            removes.add(chunkCoords);
        }
        set.removeAll(removes);
    }

    public static List<ChunkCoordIntPair> shuffle(Set<ChunkCoordIntPair> set) {
        ArrayList<ChunkCoordIntPair> list = new ArrayList<ChunkCoordIntPair>(set);
        Collections.shuffle(list);
        return list;
    }

    public static void performSpawning(World world) {
        int interval = LOTRConfig.mobSpawnInterval;
        if (interval > 0) {
            int ticks = 0;
            int dimID = world.field_73011_w.field_76574_g;
            if (ticksSinceCycle.containsKey(dimID)) {
                ticks = ticksSinceCycle.get(dimID);
            }
            ticksSinceCycle.put(dimID, --ticks);
            if (ticks > 0) {
                return;
            }
            ticks = interval;
            ticksSinceCycle.put(dimID, ticks);
        }
        LOTRSpawnerNPCs.getSpawnableChunks(world, eligibleSpawnChunks);
        ChunkCoordinates spawnPoint = world.func_72861_E();
        int totalSpawnCount = LOTRSpawnerNPCs.countNPCs(world);
        int maxSpawnCount = LOTRSpawnDamping.getNPCSpawnCap(world) * eligibleSpawnChunks.size() / 196;
        if (totalSpawnCount <= maxSpawnCount) {
            int cycles = Math.max(1, interval);
            block2: for (int c = 0; c < cycles; ++c) {
                List<ChunkCoordIntPair> shuffled = LOTRSpawnerNPCs.shuffle(eligibleSpawnChunks);
                for (ChunkCoordIntPair chunkCoords : shuffled) {
                    int k;
                    int j;
                    int i;
                    ChunkPosition chunkposition = LOTRSpawnerNPCs.getRandomSpawningPointInChunk(world, chunkCoords);
                    if (chunkposition == null || world.func_147439_a(i = chunkposition.field_151329_a, j = chunkposition.field_151327_b, k = chunkposition.field_151328_c).func_149721_r() || world.func_147439_a(i, j, k).func_149688_o() != Material.field_151579_a) continue;
                    int groups = 3;
                    block4: for (int l = 0; l < groups; ++l) {
                        int i1 = i;
                        int j1 = j;
                        int k1 = k;
                        int range = 5;
                        int yRange = 0;
                        int rangeP1 = range + 1;
                        int yRangeP1 = yRange + 1;
                        LOTRSpawnEntry.Instance spawnEntryInstance = LOTRSpawnerNPCs.getRandomSpawnListEntry(world, i1, j1, k1);
                        if (spawnEntryInstance == null) continue;
                        LOTRSpawnEntry spawnEntry = spawnEntryInstance.spawnEntry;
                        boolean isConquestSpawn = spawnEntryInstance.isConquestSpawn;
                        int spawnCount = MathHelper.func_76136_a((Random)world.field_73012_v, (int)spawnEntry.field_76301_c, (int)spawnEntry.field_76299_d);
                        int chance = spawnEntryInstance.spawnChance;
                        if (chance != 0 && world.field_73012_v.nextInt(chance) != 0) continue;
                        IEntityLivingData entityData = null;
                        int spawned = 0;
                        int attempts = spawnCount * 8;
                        for (int a = 0; a < attempts; ++a) {
                            Event.Result canSpawn;
                            LOTREntityNPC npc;
                            EntityLiving entity;
                            float f5;
                            float f;
                            float f4;
                            float f2;
                            float f3;
                            float f6;
                            float f22;
                            float f1;
                            float f7;
                            if (!world.func_72899_e(i1 += world.field_73012_v.nextInt(rangeP1) - world.field_73012_v.nextInt(rangeP1), j1 += world.field_73012_v.nextInt(yRangeP1) - world.field_73012_v.nextInt(yRangeP1), k1 += world.field_73012_v.nextInt(rangeP1) - world.field_73012_v.nextInt(rangeP1)) || !LOTRSpawnerNPCs.canNPCSpawnAtLocation(world, i1, j1, k1) || world.func_72977_a((double)(f7 = (float)i1 + 0.5f), (double)(f1 = (float)j1), (double)(f22 = (float)k1 + 0.5f), 24.0) != null || f6 * (f3 = f7 - (float)spawnPoint.field_71574_a) + f2 * (f4 = f1 - (float)spawnPoint.field_71572_b) + f * (f5 = f22 - (float)spawnPoint.field_71573_c) < 576.0f) continue;
                            try {
                                entity = (EntityLiving)spawnEntry.field_76300_b.getConstructor(World.class).newInstance(world);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                return;
                            }
                            entity.func_70012_b((double)f7, (double)f1, (double)f22, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                            if (entity instanceof LOTREntityNPC && isConquestSpawn) {
                                npc = (LOTREntityNPC)entity;
                                npc.setConquestSpawning(true);
                            }
                            if ((canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)entity, (World)world, (float)f7, (float)f1, (float)f22)) != Event.Result.ALLOW && (canSpawn != Event.Result.DEFAULT || !entity.func_70601_bi())) continue;
                            world.func_72838_d((Entity)entity);
                            if (entity instanceof LOTREntityNPC) {
                                npc = (LOTREntityNPC)entity;
                                npc.isNPCPersistent = false;
                                npc.setConquestSpawning(false);
                            }
                            if (!ForgeEventFactory.doSpecialSpawn((EntityLiving)entity, (World)world, (float)f7, (float)f1, (float)f22)) {
                                entityData = entity.func_110161_a(entityData);
                            }
                            if (c > 0 && (totalSpawnCount += entity instanceof LOTREntityNPC ? ((LOTREntityNPC)entity).getSpawnCountValue() : 1) > maxSpawnCount) break block2;
                            if (++spawned >= spawnCount) continue block4;
                        }
                    }
                }
            }
        }
    }

    private static int countNPCs(World world) {
        int count = 0;
        for (Object element : world.field_72996_f) {
            Entity entity = (Entity)element;
            if (!(entity instanceof LOTREntityNPC)) continue;
            int spawnCountValue = ((LOTREntityNPC)entity).getSpawnCountValue();
            count += spawnCountValue;
        }
        return count;
    }

    private static boolean canNPCSpawnAtLocation(World world, int i, int j, int k) {
        if (!World.func_147466_a((IBlockAccess)world, (int)i, (int)(j - 1), (int)k)) {
            return false;
        }
        Block block = world.func_147439_a(i, j - 1, k);
        world.func_72805_g(i, j - 1, k);
        boolean spawnBlock = block.canCreatureSpawn(EnumCreatureType.monster, (IBlockAccess)world, i, j - 1, k);
        return spawnBlock && block != Blocks.field_150357_h && !world.func_147439_a(i, j, k).func_149721_r() && !world.func_147439_a(i, j, k).func_149688_o().func_76224_d() && !world.func_147439_a(i, j + 1, k).func_149721_r();
    }

    private static LOTRSpawnEntry.Instance getRandomSpawnListEntry(World world, int i, int j, int k) {
        LOTRBiomeSpawnList spawnlist = null;
        BiomeGenBase biome = world.func_72807_a(i, k);
        if (biome instanceof LOTRBiome && world.field_73011_w instanceof LOTRWorldProvider) {
            LOTRBiome lotrbiome = (LOTRBiome)biome;
            LOTRWorldChunkManager worldChunkMgr = (LOTRWorldChunkManager)world.field_73011_w.field_76578_c;
            LOTRBiomeVariant variant = worldChunkMgr.getBiomeVariantAt(i, k);
            spawnlist = lotrbiome.getNPCSpawnList(world, world.field_73012_v, i, j, k, variant);
        }
        if (spawnlist != null) {
            return spawnlist.getRandomSpawnEntry(world.field_73012_v, world, i, j, k);
        }
        return null;
    }
}

